/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.nhm.eui;

import ibm.nways.analysis.dpCommon.DpResourceInstance;
import ibm.nways.jdm.BrowserApplet;
import ibm.nways.nhm.eui.NhmHelpRef;
import java.applet.Applet;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;
import jclass.bwt.JCItemEvent;
import jclass.bwt.JCItemListener;
import jclass.bwt.JCMultiColumnList;
import jclass.util.JCVector;

public class NhmReportNodeDialog
extends Dialog
implements ActionListener,
JCItemListener,
WindowListener {
    public static final int CANCEL = 1;
    public static final int OK = 2;
    private static final char DELIM = '|';
    private TextField efHost;
    private JCMultiColumnList listInst;
    private JCMultiColumnList listHosts;
    private Button pbAdd;
    private Button pbRemove;
    private Button pbOk;
    private Button pbCancel;
    private Button pbHelp;
    private Button pbEditInst;
    private TextField efValue;
    private Label lName;
    private Applet appl;
    private Vector instances;
    private DpResourceInstance defaultInstance;
    private int result = 1;
    private ResourceBundle nhmRes = ResourceBundle.getBundle("ibm.nways.nhm.eui.NhmResources");

    public NhmReportNodeDialog(Frame frame, String string, Vector vector, String[] stringArray, Applet applet) {
        super(frame, string, true);
        this.appl = applet;
        this.initializeControls();
        this.instances = vector;
        DpResourceInstance dpResourceInstance = null;
        this.defaultInstance = this.instances != null && this.instances.size() > 0 ? (DpResourceInstance)this.instances.elementAt(0) : new DpResourceInstance();
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                if (this.instances != null && this.instances.size() > n) {
                    dpResourceInstance = (DpResourceInstance)this.instances.elementAt(n);
                    this.listHosts.addItem(String.valueOf(stringArray[n]) + '|' + dpResourceInstance.getIndexString(), '|');
                } else {
                    this.listHosts.addItem(stringArray[n]);
                }
                ++n;
            }
            this.fillInstanceListBox(this.defaultInstance, false);
        }
        this.pbEditInst.setEnabled(false);
        this.pbAdd.addActionListener(this);
        this.pbRemove.addActionListener(this);
        this.pbOk.addActionListener(this);
        this.pbCancel.addActionListener(this);
        this.pbHelp.addActionListener(this);
        this.pbEditInst.addActionListener(this);
        this.listHosts.addItemListener(this);
        this.listInst.addItemListener(this);
        if (this.listInst.countItems() != 0) {
            this.listInst.select(0);
        } else {
            this.listInst.setEnabled(false);
            this.efValue.setEnabled(false);
            this.pbEditInst.setEnabled(false);
        }
        this.addWindowListener(this);
        this.pack();
        ((Component)this).setLocation(100, 100);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.pbAdd) {
            String string = this.efHost.getText();
            if (string.length() != 0) {
                string = String.valueOf(string) + '|';
                DpResourceInstance dpResourceInstance = new DpResourceInstance();
                Enumeration enumeration = this.defaultInstance.keys();
                int n = 0;
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    Vector vector = (Vector)this.listInst.getItem(n);
                    String string3 = vector.size() > 1 ? (String)vector.elementAt(1) : this.defaultInstance.dpGetInstanceDescriptor(string2);
                    dpResourceInstance.dpAddInstanceDescriptor(string2, string3);
                    ++n;
                }
                string = string.concat(dpResourceInstance.getIndexString());
                this.listHosts.addItem(string, '|');
                this.instances.addElement(dpResourceInstance);
                ((TextComponent)this.efHost).setText("");
                this.listHosts.select(this.listHosts.countItems() - 1);
                return;
            }
        } else if (actionEvent.getSource() == this.pbRemove) {
            int n = this.listHosts.getSelectedIndex();
            if (n != -999) {
                this.instances.removeElementAt(n);
                this.listHosts.deleteItem(n);
                return;
            }
        } else {
            String string;
            if (actionEvent.getSource() == this.pbOk) {
                this.result = 2;
                this.dispose();
                return;
            }
            if (actionEvent.getSource() == this.pbCancel) {
                this.result = 1;
                this.dispose();
                return;
            }
            if (actionEvent.getSource() == this.pbHelp) {
                NhmHelpRef nhmHelpRef = new NhmHelpRef(this);
                if (this.appl instanceof BrowserApplet) {
                    BrowserApplet browserApplet = (BrowserApplet)this.appl;
                    browserApplet.showHelp(nhmHelpRef);
                    return;
                }
                this.appl.getAppletContext().showDocument(nhmHelpRef.getURL(this.appl));
                return;
            }
            if (actionEvent.getSource() == this.pbEditInst && (string = this.efValue.getText()).length() != 0) {
                Vector vector = (Vector)this.listInst.getSelectedItem();
                if (vector.size() > 1) {
                    vector.setElementAt(string, 1);
                } else {
                    vector.addElement(string);
                }
                this.listInst.replaceItem(vector, this.listInst.getSelectedIndex());
                int n = this.listHosts.getSelectedIndex();
                if (n != -999) {
                    DpResourceInstance dpResourceInstance = (DpResourceInstance)this.instances.elementAt(n);
                    dpResourceInstance.dpAddInstanceDescriptor(this.lName.getText(), string);
                    vector = (Vector)this.listHosts.getSelectedItem();
                    vector.setElementAt(dpResourceInstance.getIndexString(), 1);
                    this.listHosts.replaceItem(vector, n);
                }
            }
        }
    }

    public void itemStateChanged(JCItemEvent jCItemEvent) {
        if (jCItemEvent.getSource() == this.listHosts) {
            if (jCItemEvent.getStateChange() == 1) {
                try {
                    this.fillInstanceListBox((DpResourceInstance)this.instances.elementAt(this.listHosts.getSelectedIndex()), true);
                    return;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    ((TextComponent)this.efValue).setText("");
                    return;
                }
            }
            if (this.listHosts.getSelectedIndex() == -999) {
                this.fillInstanceListBox(this.defaultInstance, false);
                return;
            }
        } else if (jCItemEvent.getSource() == this.listInst) {
            if (jCItemEvent.getStateChange() == 1) {
                Vector vector = (Vector)jCItemEvent.getItem();
                this.lName.setText((String)vector.elementAt(0));
                this.efValue.setEnabled(true);
                if (vector.size() > 1) {
                    ((TextComponent)this.efValue).setText((String)vector.elementAt(1));
                } else {
                    ((TextComponent)this.efValue).setText("");
                }
                this.pbEditInst.setEnabled(true);
                return;
            }
            if (this.listInst.getSelectedIndex() == -999) {
                this.efValue.setEnabled(false);
                this.pbEditInst.setEnabled(false);
            }
        }
    }

    public String[] getHosts() {
        JCVector jCVector = this.listHosts.getItems();
        String[] stringArray = null;
        if (jCVector.size() != 0) {
            stringArray = new String[jCVector.size()];
            int n = 0;
            while (n < jCVector.size()) {
                Object e = jCVector.elementAt(n);
                if (e instanceof Vector) {
                    Vector vector = (Vector)jCVector.elementAt(n);
                    stringArray[n] = (String)vector.elementAt(0);
                } else if (e instanceof String) {
                    stringArray[n] = (String)jCVector.elementAt(n);
                }
                ++n;
            }
        }
        return stringArray;
    }

    public Vector getInstances() {
        return this.instances;
    }

    public int getResult() {
        return this.result;
    }

    private void fillInstanceListBox(DpResourceInstance dpResourceInstance, boolean bl) {
        this.listInst.clear();
        if (dpResourceInstance != null) {
            Enumeration enumeration = dpResourceInstance.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = dpResourceInstance.dpGetInstanceDescriptor(string);
                String string3 = String.valueOf(string) + '|';
                if (bl) {
                    string3 = string3.concat(string2);
                }
                this.listInst.addItem(string3, '|');
            }
        }
        ((TextComponent)this.efValue).setText("");
    }

    private void initializeControls() {
        Insets insets = new Insets(6, 10, 6, 10);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        Label label = new Label(this.nhmRes.getString("s_Host"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.add(label);
        this.efHost = new TextField(25);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 2;
        gridBagConstraints2.gridwidth = 3;
        gridBagLayout.setConstraints(this.efHost, gridBagConstraints2);
        this.add(this.efHost);
        Label label2 = new Label(this.nhmRes.getString("s_index"));
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.fill = 0;
        gridBagConstraints3.gridx = 1;
        gridBagConstraints3.gridy = 3;
        gridBagLayout.setConstraints(label2, gridBagConstraints3);
        this.add(label2);
        Label label3 = new Label(this.nhmRes.getString("s_inst"));
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.anchor = 17;
        gridBagConstraints4.fill = 0;
        gridBagConstraints4.gridx = 2;
        gridBagConstraints4.gridy = 3;
        gridBagConstraints4.gridwidth = 2;
        gridBagLayout.setConstraints(label3, gridBagConstraints4);
        this.add(label3);
        this.pbAdd = new Button(this.nhmRes.getString("s_Add"));
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.fill = 2;
        gridBagConstraints5.gridx = 4;
        gridBagConstraints5.gridy = 2;
        gridBagConstraints5.insets = insets;
        gridBagLayout.setConstraints(this.pbAdd, gridBagConstraints5);
        this.add(this.pbAdd);
        this.pbRemove = new Button(this.nhmRes.getString("s_remove"));
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.fill = 2;
        gridBagConstraints6.gridx = 4;
        gridBagConstraints6.gridy = 3;
        gridBagConstraints6.insets = insets;
        gridBagLayout.setConstraints(this.pbRemove, gridBagConstraints6);
        this.add(this.pbRemove);
        this.listInst = new JCMultiColumnList(6, false);
        int[] nArray = new int[]{80, 45};
        this.listInst.setColumnWidths(nArray);
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        gridBagConstraints7.fill = 1;
        gridBagConstraints7.gridx = 1;
        gridBagConstraints7.gridy = 4;
        gridBagConstraints7.gridwidth = 3;
        gridBagLayout.setConstraints(this.listInst, gridBagConstraints7);
        this.add(this.listInst);
        this.lName = new Label(this.nhmRes.getString("s_Name"));
        GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
        gridBagConstraints8.fill = 0;
        gridBagConstraints8.gridx = 1;
        gridBagConstraints8.gridy = 5;
        gridBagLayout.setConstraints(this.lName, gridBagConstraints8);
        this.add(this.lName);
        this.efValue = new TextField(8);
        GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
        gridBagConstraints9.fill = 2;
        gridBagConstraints9.anchor = 17;
        gridBagConstraints9.gridx = 2;
        gridBagConstraints9.gridy = 5;
        gridBagLayout.setConstraints(this.efValue, gridBagConstraints9);
        this.add(this.efValue);
        this.pbEditInst = new Button(this.nhmRes.getString("s_Edit"));
        GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
        gridBagConstraints10.fill = 2;
        gridBagConstraints10.anchor = 17;
        gridBagConstraints10.gridx = 3;
        gridBagConstraints10.gridy = 5;
        gridBagConstraints10.insets = insets;
        gridBagLayout.setConstraints(this.pbEditInst, gridBagConstraints10);
        this.add(this.pbEditInst);
        Label label4 = new Label(this.nhmRes.getString("s_Hosts"));
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        gridBagConstraints11.fill = 0;
        gridBagConstraints11.gridx = 5;
        gridBagConstraints11.gridy = 1;
        gridBagLayout.setConstraints(label4, gridBagConstraints11);
        this.add(label4);
        this.listHosts = new JCMultiColumnList(10, false);
        GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
        gridBagConstraints12.fill = 1;
        gridBagConstraints12.gridx = 5;
        gridBagConstraints12.gridy = 2;
        gridBagConstraints12.gridheight = 4;
        gridBagLayout.setConstraints(this.listHosts, gridBagConstraints12);
        this.add(this.listHosts);
        Panel panel = new Panel();
        this.pbOk = new Button(this.nhmRes.getString("s_ok"));
        this.pbCancel = new Button(this.nhmRes.getString("s_Cancel"));
        this.pbHelp = new Button(this.nhmRes.getString("s_Help"));
        panel.add(this.pbOk);
        panel.add(this.pbCancel);
        panel.add(this.pbHelp);
        GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
        gridBagConstraints13.fill = 2;
        gridBagConstraints13.gridx = 1;
        gridBagConstraints13.gridy = 6;
        gridBagConstraints13.gridwidth = 5;
        gridBagLayout.setConstraints(panel, gridBagConstraints13);
        this.add(panel);
    }

    public Insets getInsets() {
        return new Insets(40, 15, 15, 15);
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        if (windowEvent.getWindow() == this) {
            this.result = 1;
            this.dispose();
        }
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

